function f3_show_labeled_bodies(shape_paths)


% try to load the labeled bodies data (if it exists). 
file_name           = 'labeled_bodies.mat';
file_path           = [shape_paths.shapes_source, file_name];

if ~exist(file_path, 'file')    
    disp(' ')
    disp(['Could not find the required file:']);
    disp(['    ', file_path]);
    disp(['    You need to generate this file.']);
    return;
else
    disp(' ')
    disp(['Reading labeled bodies...']);
    load(file_path, 'all_bodies_labeled_uint8'); 
    disp('    Done')
end




% Check the bodies as separate surfaces

% put the figure in the center of the screen:
screen_size         = get(0,'ScreenSize');
sw = screen_size(3);
sh = screen_size(4);
fw = 500;
fh = 500;
fx = (sw-fw)/2;
fy = (sh-fh)/2;

figure('position',[ fx, fy, fw, fh]);

hold on;
view([-15 15])
box on;
axis equal
title({'Labeled bodies from',...
        shape_paths.folder_name},...
        'interpreter', 'none')
    
% set(gca,'YDir', 'reverse')
xlabel('x');
ylabel('y');
zlabel('z');
xlim([0 size(all_bodies_labeled_uint8, 2)]);
ylim([0 size(all_bodies_labeled_uint8, 1)]);
zlim([0 size(all_bodies_labeled_uint8, 3)]);

body_inds                   = unique(all_bodies_labeled_uint8);
body_inds(body_inds == 0)   = [];
N_bodies                    = max(body_inds);
color_set                   = jet(double(N_bodies));

body_i_template             = zeros(size(all_bodies_labeled_uint8));

for body_ind = 1 : N_bodies

    body_i = body_i_template;
    body_i(all_bodies_labeled_uint8 == body_ind) = 1;
    
    % calculate the center of the shape
    blob = bwconncomp(body_i);
    blob_props = regionprops(blob,'Centroid');
    c = blob_props.Centroid;


    patch(isosurface(body_i, 0.5), 'FaceColor', color_set(body_ind, :), 'EdgeColor', 'none', 'FaceAlpha',0.15);
    text(c(1), c(2), c(3), num2str(body_ind), 'color', 0*[1 1 1 ])  

end




end